﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Media;
using Microsoft.Win32;
using Choinka.Properties;

namespace Choinka
{
    public partial class Form1 : Form
    {
        int klatka = 0;                         //indeks aktualnej klatki
        const int LICZBA_KLATEK = 8;            //liczba klatek
        Bitmap[] obrazy_prawo;                  //tablica z klatkami animacji w prawo
        Bitmap[] obrazy_lewo;                   //tablica z klatkami animacji w lewo
        string kierunek = "prawo";              //kierunek animacji, może być "prawo" lub "lewo"
        const int DZWONKI_MIN = 5000;           //minimalny czas do odtworzenia dźwięku dzwonków
        const int DZWONKI_MAX = 10000;          //maksymalny czas do odtworzenia dźwięku dzwonków

        Bitmap obraz = null;
        SoundPlayer sp = null;
        Settings ustawienia = new Settings();
        Random generator = new Random();

        public Form1()
        {
            InitializeComponent();

            string katalog = Application.StartupPath;
            sp = new SoundPlayer(System.IO.Path.Combine(katalog, "hohoho.wav"));

            //Tworzymy tablice na klatki animacji
            obrazy_lewo = new Bitmap[LICZBA_KLATEK];
            obrazy_prawo = new Bitmap[LICZBA_KLATEK];

            //inicjalizujemy tablice z klatkami animacji
            for (int i = 0; i < LICZBA_KLATEK; i++)
            {
                //do i-tego wiersza tablicy z klatkami animacji tworzymy bitmapę z odpowwiednim obrazkiem
                obrazy_prawo[i] = new Bitmap(System.IO.Path.Combine(katalog, string.Format("mikolaj\\prawo_{0}.png", i+1)));
                obrazy_lewo[i] = new Bitmap(System.IO.Path.Combine(katalog, string.Format("mikolaj\\lewo_{0}.png", i+1)));
            }

            //ustawiamy początkowy obraz na pierwszą klatkę animacji w prawo
            obraz = obrazy_prawo[0];

            this.TransparencyKey = obraz.GetPixel(0, 0);
            this.Width = obraz.Width;
            this.Height = obraz.Height;            

            ukryjToolStripMenuItem.Tag = false;

            //ustawiamy następny dzwonek za jedną sekundę (1000 milisekund) i włączamy timer
            timer3.Interval = 1000;
            timer3.Enabled = true;
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            e.Graphics.DrawImage(obraz, 0, 0, obraz.Width, obraz.Height);
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Escape) Close();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            notifyIcon1.Visible = false;
            ustawienia.x = this.Left;
            ustawienia.y = this.Top;
            ustawienia.dzwiek = toolStripMenuItem2.Checked;
            ustawienia.Save();

            for (; Opacity > 0; Opacity -= 0.01) System.Threading.Thread.Sleep(5);
        }
        
        Point? przenoszeniePoczatek = null;

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left) przenoszeniePoczatek = new Point(e.X, e.Y);            
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {            
            if(przenoszeniePoczatek.HasValue) 
            {
                int dx = e.X - przenoszeniePoczatek.Value.X;
                int dy = e.Y - przenoszeniePoczatek.Value.Y;
                this.Left += dx;
                this.Top += dy;
            }
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            przenoszeniePoczatek = null;
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void zawszeNaWierzchuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.TopMost = zawszeNaWierzchuToolStripMenuItem.Checked;
        }

        

        private void ukryjToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!(bool)ukryjToolStripMenuItem.Tag)
            {
                this.Hide();
                ukryjToolStripMenuItem.Text = "Pokaż";
                ukryjToolStripMenuItem.Tag = true;
            }
            else
            {
                this.Show();
                ukryjToolStripMenuItem.Text = "Ukryj";
                ukryjToolStripMenuItem.Tag = false;
            }
        }

        private void oAutorzeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("KURS .NET");
        }

        private void stronaUMKToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("http://www.umk.edu.pl/");
        }

        private void notifyIcon1_DoubleClick(object sender, EventArgs e)
        {
            notifyIcon1.BalloonTipTitle = "Gwiazdka " + DateTime.Now.Year;
            notifyIcon1.BalloonTipText = "Wszystkiego najlepszego";
            notifyIcon1.BalloonTipText += "\n" + notifyIcon1.Text;
            notifyIcon1.ShowBalloonTip(2000);
        }

        private void notifyIcon1_MouseMove(object sender, MouseEventArgs e)
        {
            notifyIcon1.Text = "Do gwiazdki pozostało jeszcze " + (24 - DateTime.Now.Day).ToString() + " dni!";
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            if (toolStripMenuItem2.Checked) sp.PlayLooping();
            else sp.Stop();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.Left = ustawienia.x;
            this.Top = ustawienia.y;
            toolStripMenuItem2.Checked = ustawienia.dzwiek; toolStripMenuItem2_Click(null, null);
            if (toolStripMenuItem2.Checked) sp.PlayLooping();
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            try
            {
                RegistryKey kluczRejestruRun = Registry.CurrentUser.OpenSubKey(@"Software\Microsoft\Windows\CurrentVersion\Run", true);
                if (kluczRejestruRun.GetValueNames().Contains("Choinka")) kluczRejestruRun.DeleteValue("Choinka");
                kluczRejestruRun.SetValue("Choinka", "\"" + Application.ExecutablePath + "\"");
                kluczRejestruRun.Close();
                MessageBox.Show("Dodano zapis w rejestrze");
            }
            catch(Exception exc)
            {
                MessageBox.Show("Dodanie zapisu w rejestrze nie powiodło się.\nBłąd: "+exc.Message,"Choinka",MessageBoxButtons.OK,MessageBoxIcon.Error);
            }
        }

        //Timer1 jest odpowiedzialny za zmianę klatek co określony czas
        private void timer1_Tick(object sender, EventArgs e)
        {
            klatka++;                               //zwiększamy numer klatki
            if (klatka >= LICZBA_KLATEK)            //jeśli osiągnęliśmy limit, to wracamy do pierwszej klatki
            {
                klatka = 0;
            }

            //w zależności od kierunku ustawiamy obraz na odpowiednią klatkę animacji z odpowiedniej tablicy
            if (kierunek == "prawo")
            {
                obraz = obrazy_prawo[klatka];
            }
            else
            {
                obraz = obrazy_lewo[klatka];
            }

            //wymuszamy odrysowanie okna
            this.Refresh();
        }

        //Timer 2 jest odpowiedzialny za zmianę pozycji okna
        private void timer2_Tick(object sender, EventArgs e)
        {
            //najpierw sprawdzamy w którym kierunku
            if( kierunek == "prawo" )
            {
                this.Left += 5;                                         //aktualizujemy pozycję okna (przesuwamy o pięć w prawo)
                if (this.Left > Screen.PrimaryScreen.Bounds.Right)      //sprawdzamy, czy okno w całości wyjechało poza ekran (czyli czy lewa krawędź okna przekroczyła szerokość ekranu)
                {
                    kierunek = "lewo";                                  //jeśli tak to zmieniamy kierunek
                    klatka = 0;                                         //i wracamy do początkowej klatki
                }
            }
            else                                                        //analogicznie postępujemy dla kierunku lewo
            {
                this.Left -= 5;
                if (this.Right < 0)                         //sprawdzamy czy prawa krawędź ekranu wyszła poza ekran
                {
                    kierunek = "prawo";
                    klatka = 0;
                }
            }

        }

        //Timer 3 jest odpowiedzialny za odtwarzanie dźwięku dzwonków co jakiś czas
        private void timer3_Tick(object sender, EventArgs e)
        {
            timer3.Enabled = false;                                         //zatrzymujemy zegar

            if (toolStripMenuItem2.Checked) sp.Play();                      //jeśli dźwięki są włączone, odtwarzamy dźwięk dzwonków

            timer3.Interval = generator.Next(DZWONKI_MIN, DZWONKI_MAX);     //ustawiamy losowy odstęp czasu do następnego odtworzenia dzwonków
            timer3.Enabled = true;                                          //włączamy zegar
        }
    }
}
